

<?php $__env->startSection('main'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="fas fa-cube"></i> Products Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Products</li>
                    </ol>
                </div>
            </div>
        </div>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Info boxes -->
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-info"><i class="fas fa-cube"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Products</span>
                        <span class="info-box-number" id="total-records"><?php echo e($totalProducts ?? 0); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-primary"><i class="fas fa-warehouse"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Stock Phones</span>
                        <span class="info-box-number" id="stock-phones"><?php echo e($stockPhones ?? 0); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-secondary"><i class="fas fa-box"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Stock Accessories</span>
                        <span class="info-box-number" id="stock-accessories"><?php echo e($stockAccessories ?? 0); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bulk Actions Panel -->
        <div class="row mb-3" id="bulk-actions-panel" style="display: none;">
            <div class="col-12">
                <div class="alert alert-info d-flex justify-content-between align-items-center">
                    <div>
                        <i class="fas fa-check-square"></i>
                        <strong><span id="selected-count">0</span> product(s) selected</strong>
                        <span id="selected-products-preview" class="ml-2 text-muted"></span>
                    </div>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-danger" id="bulk-delete-btn">
                            <i class="fas fa-trash"></i> Delete Selected
                        </button>
                        <button type="button" class="btn btn-sm btn-secondary" id="clear-selection-btn">
                            <i class="fas fa-times"></i> Clear Selection
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Panel -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Products</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('product.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Add Product
                    </a>
                </div>
            </div>
            
            <div class="card-body border-bottom">
                <form id="filter-form" class="row g-3">
                    <div class="col-md-4">
                        <label for="search" class="form-label">Search</label>
                        <input type="text" class="form-control" id="search" name="search" placeholder="Search...">
                    </div>
                    
                    <div class="col-md-3">
                        <label for="date_from" class="form-label">Date From</label>
                        <input type="date" class="form-control" id="date_from" name="date_from">
                    </div>
                    <div class="col-md-3">
                        <label for="date_to" class="form-label">Date To</label>
                        <input type="date" class="form-control" id="date_to" name="date_to">
                    </div>
                    
                    <div class="col-md-3">
                        <label for="condition_filter" class="form-label">Condition</label>
                        <select class="form-control" id="condition_filter" name="condition_filter">
                            <option value="">All Conditions</option>
                            <option value="new">New</option>
                            <option value="used">Used</option>
                            <option value="refurbished">Refurbished</option>
                            <option value="old">Old</option>
                        </select>
                    </div>
                    
                    <div class="col-md-3">
                        <label for="stock_filter" class="form-label">Stock Status</label>
                        <select class="form-control" id="stock_filter" name="stock_filter">
                            <option value="">All Stock</option>
                            <option value="in_stock">In Stock</option>
                            <option value="low_stock">Low Stock (5 or less)</option>
                            <option value="out_of_stock">Out of Stock</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="button" id="filter-btn" class="btn btn-info me-2">
                            <i class="fas fa-search"></i> Filter
                        </button>
                        <button type="button" id="clear-btn" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Clear
                        </button>
                    </div>
                </form>
            </div>
            
            <div class="card-body">
                <!-- Data Table -->
                <table id="products-table" class="table table-bordered table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th><input type="checkbox" id="select-all-products" title="Select All"></th>
                            <th>SL</th>
                            <th>Type</th>
                            <th>Name</th>
                            <th>Brand</th>
                            <th>Model</th>
                            <th>IMEI/SN</th>
                            <th>Condition</th>
                            <th>Stock</th>
                            <th>Buy Price</th>
                            <th>Sell Price</th>
                            <th>Added Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be loaded via AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </section>

<?php $__env->startPush('style'); ?>
<style>
    /* Bulk Actions Panel Styling */
    #bulk-actions-panel {
        position: sticky;
        top: 0;
        z-index: 100;
        margin-top: -15px;
        margin-bottom: 15px;
    }
    
    #bulk-actions-panel .alert {
        margin-bottom: 0;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        animation: slideDown 0.3s ease-out;
    }
    
    @keyframes slideDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Checkbox styling */
    .product-checkbox, #select-all-products {
        transform: scale(1.2);
        margin: 0;
    }
    
    /* Table row highlight when selected */
    .product-row-selected {
        background-color: rgba(0, 123, 255, 0.1) !important;
    }
    
    /* Info box styling */
    .info-box {
        box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
        border-radius: .25rem;
        background-color: #fff;
        display: flex;
        margin-bottom: 1rem;
        min-height: 80px;
        padding: .5rem;
        position: relative;
        width: 100%;
    }

    .info-box .info-box-icon {
        border-radius: .25rem;
        align-items: center;
        display: flex;
        font-size: 1.875rem;
        justify-content: center;
        text-align: center;
        width: 70px;
        color: rgba(255,255,255,.8);
        background: rgba(0,0,0,.1);
    }

    .info-box .info-box-content {
        display: flex;
        flex-direction: column;
        justify-content: center;
        line-height: 1.8;
        margin-left: 10px;
        padding: 0 10px;
    }

    .info-box .info-box-text {
        display: block;
        font-size: .875rem;
        font-weight: 600;
        text-transform: uppercase;
        white-space: nowrap;
    }

    .info-box .info-box-number {
        display: block;
        font-size: 1.125rem;
        font-weight: 700;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        // Edit Product Function
        function editProduct(id) {
            if (!id) {
                window.notificationSystem.error('Product ID Required', 'Please select a valid product to edit.');
                return;
            }

            console.log('Editing product with ID:', id);
            
            // Show loading notification
            window.notificationSystem.info('Redirecting...', 'Opening product edit page...', { duration: 1500 });
            
            // Add small delay for better UX
            setTimeout(() => {
                window.location.href = '<?php echo e(route("product.index")); ?>/' + id + '/edit';
            }, 300);
        }

        // Delete Product Function
        function deleteProduct(id) {
            if (!id) {
                window.notificationSystem.error('Product ID Required', 'Please select a valid product to delete.');
                return;
            }

            console.log('Attempting to delete product with ID:', id);

            // Use the advanced confirmation dialog with sound
            window.notificationSystem.confirm({
                title: 'Delete Product',
                message: 'Are you sure you want to permanently delete this product? This action cannot be undone.',
                confirmText: 'Yes, Delete',
                cancelText: 'Cancel',
                type: 'danger',
                onConfirm: function() {
                    console.log('User confirmed deletion');
                    
                    // Show deleting notification
                    window.notificationSystem.info('Deleting...', 'Please wait while we delete the product...', { duration: 3000 });
                    
                    var form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '<?php echo e(route("product.index")); ?>/' + id;
                    form.style.display = 'none';

                    var csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = '<?php echo e(csrf_token()); ?>';
                    form.appendChild(csrfInput);

                    var methodInput = document.createElement('input');
                    methodInput.type = 'hidden';
                    methodInput.name = '_method';
                    methodInput.value = 'DELETE';
                    form.appendChild(methodInput);

                    document.body.appendChild(form);
                    form.submit();
                },
                onCancel: function() {
                    console.log('User cancelled deletion');
                    window.notificationSystem.info('Cancelled', 'Product deletion was cancelled.', { duration: 2000 });
                }
            });
        }

        // Bulk Selection Functions
        function updateBulkActionsPanel() {
            var selectedCheckboxes = $('.product-checkbox:checked');
            var selectedCount = selectedCheckboxes.length;
            
            if (selectedCount > 0) {
                $('#bulk-actions-panel').show();
                $('#selected-count').text(selectedCount);
                
                var productNames = [];
                selectedCheckboxes.slice(0, 3).each(function() {
                    productNames.push($(this).data('product-name'));
                });
                
                var previewText = productNames.join(', ');
                if (selectedCount > 3) {
                    previewText += ` and ${selectedCount - 3} more`;
                }
                $('#selected-products-preview').text('(' + previewText + ')');
            } else {
                $('#bulk-actions-panel').hide();
                $('#selected-count').text('0');
                $('#selected-products-preview').text('');
            }
            
            var totalCheckboxes = $('.product-checkbox').length;
            var allSelected = selectedCount === totalCheckboxes && totalCheckboxes > 0;
            var someSelected = selectedCount > 0 && selectedCount < totalCheckboxes;
            
            $('#select-all-products').prop('checked', allSelected);
            $('#select-all-products').prop('indeterminate', someSelected);
        }

        // Bulk Delete Function
        function bulkDeleteProducts() {
            var selectedCheckboxes = $('.product-checkbox:checked');
            var selectedIds = [];
            var productNames = [];
            
            selectedCheckboxes.each(function() {
                selectedIds.push($(this).val());
                productNames.push($(this).data('product-name'));
            });
            
            if (selectedIds.length === 0) {
                window.notificationSystem.warning('No Selection', 'Please select at least one product to delete.');
                return;
            }
            
            // Create detailed message for confirmation
            var productList = productNames.slice(0, 5).join('<br>• ');
            if (productNames.length > 5) {
                productList += '<br>• ... and ' + (productNames.length - 5) + ' more products';
            }
            
            // Use advanced confirmation dialog
            window.notificationSystem.confirm({
                title: `Delete ${selectedIds.length} Product${selectedIds.length > 1 ? 's' : ''}`,
                message: `You are about to permanently delete the following products:<br><br><strong>• ${productList}</strong><br><br>This action cannot be undone!`,
                confirmText: `Yes, Delete ${selectedIds.length} Product${selectedIds.length > 1 ? 's' : ''}`,
                cancelText: 'Cancel',
                type: 'danger',
                onConfirm: function() {
                    console.log('User confirmed bulk deletion of products:', selectedIds);
                    
                    // Show progress notification
                    window.notificationSystem.info('Bulk Delete in Progress', `Deleting ${selectedIds.length} product(s)... Please wait.`, { 
                        duration: 10000,
                        pulse: true 
                    });
                    
                    $('#bulk-delete-btn').html('<i class="fas fa-spinner fa-spin"></i> Deleting...').prop('disabled', true);
                    
                    $.ajax({
                        url: '<?php echo e(route("product.bulkDelete")); ?>',
                        method: 'DELETE',
                        data: {
                            product_ids: selectedIds,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                // Clear any existing notifications
                                window.notificationSystem.clear();
                                
                                // Show success notification with sound
                                window.notificationSystem.delete(
                                    'Bulk Delete Successful!', 
                                    `Successfully deleted ${response.deleted_count} product(s). The products have been permanently removed from your inventory. All sales history has been preserved for reporting purposes.`,
                                    { duration: 7000, pulse: true }
                                );
                                
                                // Reload table
                                var table = $('#products-table').DataTable();
                                table.ajax.reload(function() {
                                    $('.product-checkbox').prop('checked', false);
                                    $('#select-all-products').prop('checked', false).prop('indeterminate', false);
                                    $('.product-row-selected').removeClass('product-row-selected');
                                    updateBulkActionsPanel();
                                    console.log('Table reloaded after bulk deletion');
                                });
                            } else {
                                window.notificationSystem.error('Bulk Delete Failed', response.message || 'An error occurred while deleting products.');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('Bulk deletion failed:', xhr.responseText);
                            window.notificationSystem.error('Bulk Delete Error', 'Failed to delete products. Please check your connection and try again.');
                        },
                        complete: function() {
                            $('#bulk-delete-btn').html('<i class="fas fa-trash"></i> Delete Selected').prop('disabled', false);
                        }
                    });
                },
                onCancel: function() {
                    console.log('User cancelled bulk deletion');
                    window.notificationSystem.info('Bulk Delete Cancelled', 'No products were deleted.', { duration: 2000 });
                }
            });
        }

        // Initialize DataTable and event handlers
        $(function() {
            console.log('Product management page loaded successfully');
            
            // Initialize DataTable
            var table = $('#products-table').DataTable({
                processing: true,
                serverSide: false,
                ajax: {
                    url: '<?php echo e(route("product.index")); ?>',
                    data: function(d) {
                        d.search = $('#search').val();
                        d.date_from = $('#date_from').val();
                        d.date_to = $('#date_to').val();
                        d.condition_filter = $('#condition_filter').val();
                        d.stock_filter = $('#stock_filter').val();
                    },
                    dataSrc: function(json) {
                        $('#total-records').text(json.recordsTotal || 0);
                        $('#stock-phones').text(json.totalPhones || 0);
                        $('#stock-accessories').text(json.totalAccessories || 0);
                        return json.data || [];
                    }
                },
                columns: [
                    { data: 'checkbox', orderable: false, searchable: false },
                    { data: 'sl', orderable: false },
                    { data: 'type' },
                    { data: 'name' },
                    { data: 'brand' },
                    { data: 'model' },
                    { data: 'imei_or_sn' },
                    { data: 'condition' },
                    { data: 'stock' },
                    { data: 'buy_price' },
                    { data: 'sell_price' },
                    { data: 'created_at' },
                    { data: 'actions', orderable: false, searchable: false }
                ],
                responsive: true,
                lengthChange: true,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                autoWidth: false,
                pageLength: 25,
                order: [[1, 'desc']]
            });

            // Filter button click
            $('#filter-btn').on('click', function() {
                table.ajax.reload();
            });

            // Clear button click
            $('#clear-btn').on('click', function() {
                $('#filter-form')[0].reset();
                table.ajax.reload();
            });

            // Select All checkbox functionality
            $(document).on('change', '#select-all-products', function() {
                var isChecked = $(this).prop('checked');
                $('.product-checkbox').prop('checked', isChecked);
                
                $('.product-checkbox').each(function() {
                    var $row = $(this).closest('tr');
                    if (isChecked) {
                        $row.addClass('product-row-selected');
                    } else {
                        $row.removeClass('product-row-selected');
                    }
                });
                
                updateBulkActionsPanel();
            });
            
            // Individual checkbox change
            $(document).on('change', '.product-checkbox', function() {
                var $row = $(this).closest('tr');
                if ($(this).prop('checked')) {
                    $row.addClass('product-row-selected');
                } else {
                    $row.removeClass('product-row-selected');
                }
                updateBulkActionsPanel();
            });
            
            // Bulk delete button click
            $(document).on('click', '#bulk-delete-btn', function() {
                bulkDeleteProducts();
            });
            
            // Clear selection button click
            $(document).on('click', '#clear-selection-btn', function() {
                $('.product-checkbox').prop('checked', false);
                $('#select-all-products').prop('checked', false).prop('indeterminate', false);
                $('.product-row-selected').removeClass('product-row-selected');
                updateBulkActionsPanel();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/pos24.3/resources/views/product/index.blade.php ENDPATH**/ ?>